/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.indunet.fastproto.annotation.DataType;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.mapper.CodecMapper;

public class Resolver {
    protected static ConcurrentHashMap<Class<?>, Graph> graphs = new ConcurrentHashMap();
    protected static ResolvePipeline resolveClassFlow = ResolvePipeline.getClassPipeline();
    protected static ResolvePipeline resolveFieldFlow = ResolvePipeline.getFieldPipeline();

    public static Graph resolve(Class<?> protocolClass) {
        return graphs.computeIfAbsent(protocolClass, __ -> {
            Graph graph = new Graph();
            ArrayDeque deque = new ArrayDeque();
            Reference reference = Reference.builder().protocolClass(protocolClass).referenceType(Reference.ReferenceType.CLASS).build();
            resolveClassFlow.process(reference);
            graph.addClass(reference);
            Arrays.stream(protocolClass.getDeclaredFields()).peek(f -> f.setAccessible(true)).forEach(deque::add);
            while (!deque.isEmpty()) {
                Reference s;
                Field field = (Field)deque.remove();
                if (Resolver.isData(field)) {
                    Reference r = Reference.builder().field(field).referenceType(Reference.ReferenceType.FIELD).build();
                    resolveFieldFlow.process(r);
                    graph.addReference(r);
                    continue;
                }
                if (Resolver.isClass(field)) {
                    if (graph.contains(field.getType())) {
                        Reference ref = graph.getReference(field.getType()).withField(field);
                        graph.addReference(ref);
                        continue;
                    }
                    s = Reference.builder().protocolClass(field.getType()).field(field).referenceType(Reference.ReferenceType.CLASS).build();
                    resolveClassFlow.process(s);
                    graph.addClass(s);
                    graph.addReference(s);
                    Arrays.stream(field.getType().getDeclaredFields()).peek(f -> f.setAccessible(true)).forEach(deque::add);
                    continue;
                }
                s = Reference.builder().field(field).referenceType(Reference.ReferenceType.INVALID).build();
                graph.addReference(s);
            }
            return graph;
        });
    }

    protected static boolean isClass(Field field) {
        Predicate<Field> condition = f -> CodecMapper.isSupported(field.getType());
        return !condition.or(f -> Modifier.isTransient(f.getModifiers())).or(f -> f.isEnumConstant() || Enum.class.isAssignableFrom(f.getType())).or(f -> EnumSet.class.isAssignableFrom(f.getType())).or(f -> f.getType().isArray()).or(f -> f.getType() == Class.class).or(f -> f.getType() == Object.class).or(f -> List.class.isAssignableFrom(f.getType())).or(f -> Map.class.isAssignableFrom(f.getType())).or(f -> Set.class.isAssignableFrom(f.getType())).test(field);
    }

    protected static boolean isData(Field field) {
        Predicate<Field> isTypeFlag = f -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).anyMatch(t -> t.isAnnotationPresent(DataType.class));
        return isTypeFlag.test(field);
    }
}

