/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.io;

import java.util.Arrays;
import org.indunet.fastproto.exception.CodecException;

public final class ByteBuffer {
    byte[] bytes;
    int length;
    boolean fixed;

    public ByteBuffer() {
        this.fixed = false;
        this.bytes = new byte[256];
        this.length = 0;
    }

    public ByteBuffer(int length) {
        this(new byte[length]);
    }

    public ByteBuffer(byte[] bytes) {
        this.fixed = true;
        this.bytes = bytes;
        this.length = bytes.length;
    }

    public void andEq(int offset, byte value) {
        byte tmp = 0;
        if (offset < this.length) {
            tmp = (byte)(this.get(offset) & value);
        }
        this.set(offset, tmp);
    }

    public void orEq(int offset, byte value) {
        byte tmp = value;
        if (offset < this.length) {
            tmp = (byte)(this.get(offset) | value);
        }
        this.set(offset, tmp);
    }

    public void set(int offset, byte value) {
        int o = this.reverse(offset);
        this.grow(o);
        this.bytes[o] = value;
    }

    private void grow(int index) {
        if (index >= this.length) {
            this.length = index + 1;
        } else if (this.length == this.bytes.length && !this.fixed) {
            this.bytes = Arrays.copyOf(this.bytes, this.bytes.length * 2);
            this.grow(index);
        }
    }

    public byte get(int offset) {
        int o = this.reverse(offset);
        if (o >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[o];
    }

    public int reverse(int offset) {
        if (offset >= 0) {
            return offset;
        }
        if (this.fixed) {
            int o = this.bytes.length + offset;
            if (o >= 0) {
                return o;
            }
            throw new IllegalArgumentException(String.format("Illegal offset %d", o));
        }
        throw new CodecException("Reverse addressing is only available with fixed length");
    }

    public int reverse(int offset, int length) {
        if (length > 0) {
            return length;
        }
        if (this.fixed && length < 0) {
            int o = this.reverse(offset);
            int l = this.bytes.length + length - o + 1;
            if (l > 0) {
                return l;
            }
            throw new IllegalArgumentException(String.format("Illegal length %d", l));
        }
        throw new CodecException("Reverse addressing is only available with fixed length");
    }

    public int size() {
        return this.length;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.bytes, this.length);
    }
}

