/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline.encode;

import java.util.List;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class EncodeFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        Graph graph = context.getGraph();
        Object object = context.getObject();
        ByteBufferOutputStream outputStream = context.getOutputStream();
        List<Reference> refs = graph.getValidReferences();
        graph.copy(object);
        refs.stream().filter(r -> r.getEncodingIgnore() == false).filter(r -> r.getValue().get() != null).forEach(r -> {
            try {
                r.encoder(outputStream);
            }
            catch (EncodingException e) {
                throw new EncodingException(String.format("Fail encoding field %s", r.getField().toString()), e);
            }
        });
        this.forward(context);
    }

    @Override
    public long getCode() {
        return 512L;
    }
}

