/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int64Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class Int64Codec
implements Codec<Long> {
    @Override
    public Long decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int64Type type = context.getDataTypeAnnotation(Int64Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return inputStream.readInt64(type.offset(), order);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int64 type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Long value) {
        try {
            Int64Type type = context.getDataTypeAnnotation(Int64Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeInt64(type.offset(), order, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int64 type.", e);
        }
    }
}

