/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.Int8Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class Int8Codec
implements Codec<Integer> {
    @Override
    public Integer decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
            return inputStream.readInt8(type.offset());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int8(int) type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Integer value) {
        try {
            Int8Type type = context.getDataTypeAnnotation(Int8Type.class);
            outputStream.writeInt8(type.offset(), value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int8(int) type.", e);
        }
    }
}

