/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int16Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class ShortCodec
implements Codec<Short> {
    @Override
    public Short decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return inputStream.readShort(type.offset(), order);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int16(short) type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Short value) {
        try {
            Int16Type type = context.getDataTypeAnnotation(Int16Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeShort(type.offset(), order, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int16(short) type.", e);
        }
    }
}

