/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.math.BigInteger;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class UInt64Codec
implements Codec<BigInteger> {
    @Override
    public BigInteger decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            UInt64Type type = context.getDataTypeAnnotation(UInt64Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return inputStream.readUInt64(type.offset(), order);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint64 type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, BigInteger value) {
        try {
            UInt64Type type = context.getDataTypeAnnotation(UInt64Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeUInt64(type.offset(), order, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding uint64 type.", e);
        }
    }
}

