/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.text.MessageFormat;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.indunet.fastproto.annotation.Validator;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.ResolvingException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.mapper.CodecMapper;
import org.indunet.fastproto.mapper.JavaTypeMapper;

public class CodecFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        BiConsumer<ByteBufferOutputStream, ? super Object> encoder;
        Function func;
        Class javaType;
        Function<ByteBufferInputStream, ?> decoder;
        CodecContext context = CodecContext.builder().dataTypeAnnotation(reference.getDataTypeAnnotation()).fieldType(reference.getField().getType()).field(reference.getField()).defaultByteOrder(reference.getByteOrder()).defaultBitOrder(reference.getBitOrder()).build();
        if (reference.getDecodingFormulaClass() != null) {
            decoder = CodecMapper.getDecoder(context, reference.getDecodingFormulaClass());
            reference.setDecoder(decoder);
        } else if (reference.getDecodingLambda() != null) {
            javaType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
            Function<ByteBufferInputStream, ?> decoder2 = CodecMapper.getDefaultDecoder(context, javaType);
            func = reference.getDecodingLambda();
            reference.setDecoder(decoder2.andThen(func));
        } else {
            decoder = CodecMapper.getDecoder(context, null);
            reference.setDecoder(decoder);
        }
        if (reference.getEncodingFormulaClass() != null) {
            encoder = CodecMapper.getEncoder(context, reference.getEncodingFormulaClass());
            reference.setEncoder(encoder);
        } else if (reference.getEncodingLambda() != null) {
            javaType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
            BiConsumer<ByteBufferOutputStream, ? super Object> encoder2 = CodecMapper.getDefaultEncoder(context, javaType);
            func = reference.getEncodingLambda();
            reference.setEncoder((outputStream, value) -> encoder2.accept((ByteBufferOutputStream)outputStream, func.apply(value)));
        } else {
            encoder = CodecMapper.getEncoder(context, null);
            reference.setEncoder(encoder);
        }
        try {
            ValidatorContext ctx = ValidatorContext.builder().field(reference.getField()).typeAnnotation(reference.getDataTypeAnnotation()).protocolType(reference.getProtocolType()).decodingFormulaClass(reference.getDecodingFormulaClass()).encodingFormulaClass(reference.getEncodingFormulaClass()).build();
            Validator validator = reference.getDataTypeAnnotation().annotationType().getAnnotation(Validator.class);
            TypeValidator.create(validator.value()).process(ctx);
        }
        catch (ResolvingException e) {
            throw new ResolvingException(MessageFormat.format("Fail resolving the filed of %s", reference.getField().toString()), e);
        }
        this.forward(reference);
    }
}

