/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline;

import java.util.Arrays;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.pipeline.PipelineContext;
import org.indunet.fastproto.pipeline.decode.DecodeFlow;
import org.indunet.fastproto.pipeline.encode.EncodeFlow;

public abstract class Pipeline<T> {
    protected static Class<? extends Pipeline>[] decodeFlowClasses = new Class[]{DecodeFlow.class};
    protected static Class<? extends Pipeline>[] encodeFlowClasses = new Class[]{EncodeFlow.class};
    Pipeline<T> next = null;
    protected static Pipeline decodePipeline = new DecodeFlow();
    protected static Pipeline encodePipeline = new EncodeFlow();
    protected static Pipeline<ValidatorContext> validateFlow;

    public abstract void process(T var1);

    public Pipeline<T> setNext(Pipeline<T> next) {
        this.next = next;
        return this.next;
    }

    public void forward(T context) {
        if (this.next != null) {
            this.next.process(context);
        }
    }

    public Pipeline<T> append(Class<? extends Pipeline<T>> clazz) {
        Pipeline<T> temp = this;
        while (temp.next != null) {
            temp = temp.next;
        }
        try {
            temp.setNext(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DecodingException("Fail creating decoding flow.", e);
        }
        return this;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (this.next != null) {
            return String.format("%s -> %s", name, this.next);
        }
        return name;
    }

    public abstract long getCode();

    public static Pipeline<PipelineContext> getDecodeFlow() {
        return decodePipeline;
    }

    public static Pipeline<PipelineContext> getEncodeFlow() {
        return encodePipeline;
    }

    public static Pipeline create(Class<? extends Pipeline>[] flowClasses, long codecFeature) {
        Pipeline[] array = (Pipeline[])Arrays.stream(flowClasses).map(c -> {
            try {
                return (Pipeline)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException("Fail creating decoding flow.", e);
            }
        }).filter(f -> (f.getCode() & codecFeature) == 0L).toArray(Pipeline[]::new);
        Pipeline flow = array[0];
        for (int i = 1; i < array.length; ++i) {
            flow.setNext(array[i]);
            flow = flow.next;
        }
        return array[0];
    }

    public static <T> Pipeline<T> create(Class<? extends Pipeline<T>>[] pipelines) {
        return Pipeline.create(pipelines, 0L);
    }
}

