/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import org.indunet.fastproto.checksum.CRC;

public class CRC32
extends CRC {
    public static final int DEFAULT_POLYNOMIAL = 79764919;
    public static final int DEFAULT_INITIAL_VALUE = -1;
    protected static final int[] DEFAULT_TABLE = new int[256];
    protected int polynomial;
    protected int initialValue;
    protected int[] crcTable;

    protected static int[] buildTable(int polynomial) {
        int[] table = new int[256];
        for (int i = 0; i < 256; ++i) {
            int crc = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((crc & Integer.MIN_VALUE) != 0) {
                    crc = crc << 1 ^ polynomial;
                    continue;
                }
                crc <<= 1;
            }
            table[i] = crc;
        }
        return table;
    }

    public CRC32() {
        this.initialValue = -1;
        this.polynomial = 79764919;
        this.crcTable = DEFAULT_TABLE;
    }

    public CRC32(int polynomial, int initialValue) {
        this.polynomial = polynomial;
        this.initialValue = initialValue;
        this.crcTable = polynomial == 79764919 ? DEFAULT_TABLE : CRC32.buildTable(polynomial);
    }

    @Override
    public int getPolynomial() {
        return this.polynomial;
    }

    @Override
    public void setPolynomial(int polynomial) {
        this.polynomial = polynomial;
        this.crcTable = polynomial == 79764919 ? DEFAULT_TABLE : CRC32.buildTable(polynomial);
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public int calculate(byte[] data) {
        int crc = this.initialValue;
        for (byte b : data) {
            b = CRC32.reverseBits(b);
            int tableIndex = crc >>> 24 ^ b & 0xFF;
            crc = crc << 8 ^ this.crcTable[tableIndex];
        }
        return ~this.reverseBits(crc, 32);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int crc = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((crc & Integer.MIN_VALUE) != 0) {
                    crc = crc << 1 ^ 0x4C11DB7;
                    continue;
                }
                crc <<= 1;
            }
            CRC32.DEFAULT_TABLE[i] = crc;
        }
    }
}

