/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import org.indunet.fastproto.annotation.Checksum;
import org.indunet.fastproto.checksum.CRC16;
import org.indunet.fastproto.checksum.CRC32;
import org.indunet.fastproto.checksum.CRC8;

public class ChecksumUtils {
    public static int crc8(byte[] data) {
        return new CRC8().calculate(data);
    }

    public static int crc16(byte[] data) {
        return new CRC16().calculate(data);
    }

    public static int crc32(byte[] data) {
        return new CRC32().calculate(data);
    }

    public static long calculate(byte[] data, int offset, int length, Checksum.Type type) {
        byte[] slice = new byte[length];
        System.arraycopy(data, offset, slice, 0, length);
        switch (type) {
            case CRC32: {
                return (long)ChecksumUtils.crc32(slice) & 0xFFFFFFFFL;
            }
            case CRC8: {
                return ChecksumUtils.crc8(slice) & 0xFF;
            }
        }
        return ChecksumUtils.crc16(slice) & 0xFFFF;
    }
}

