/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.annotation.AsciiType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class AsciiCodec
implements Codec<Character> {
    @Override
    public Character decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            AsciiType type = context.getDataTypeAnnotation(AsciiType.class);
            int value = inputStream.readUInt8(type.offset());
            if (value > 127) {
                throw new DecodingException(String.format("%d is not valid ascii.", value));
            }
            return Character.valueOf((char)value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding ascii type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Character value) {
        try {
            AsciiType type = context.getDataTypeAnnotation(AsciiType.class);
            if (value.charValue() > '\u007f') {
                throw new EncodingException(String.format("%c is not valid ascii.", value));
            }
            outputStream.writeUInt8(type.offset(), value.charValue());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding ascii type.", e);
        }
    }
}

