/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.BinaryType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class BinaryCodec
implements Codec<byte[]> {
    @Override
    public byte[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            BinaryType type = context.getDataTypeAnnotation(BinaryType.class);
            return inputStream.readBytes(type.offset(), type.length());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding binary type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, byte[] values) {
        try {
            BinaryType type = context.getDataTypeAnnotation(BinaryType.class);
            int l = outputStream.toByteBuffer().reverse(type.offset(), type.length());
            outputStream.writeBytes(type.offset(), Arrays.copyOfRange(values, 0, l));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding binary type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Byte>> {
        @Override
        public Collection<Byte> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (byte b : BinaryCodec.this.decode(context, inputStream)) {
                    collection.add(b);
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Byte> collection) {
            byte[] bs = new byte[collection.size()];
            Byte[] values = (Byte[])collection.stream().toArray(Byte[]::new);
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = values[i];
            });
            BinaryCodec.this.encode(context, outputStream, bs);
        }
    }

    public class WrapperCodec
    implements Codec<Byte[]> {
        @Override
        public Byte[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            byte[] bs = BinaryCodec.this.decode(context, inputStream);
            Byte[] values = new Byte[bs.length];
            IntStream.range(0, bs.length).forEach(i -> {
                values[i] = bs[i];
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Byte[] binary) {
            byte[] bs = new byte[binary.length];
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = binary[i];
            });
            BinaryCodec.this.encode(context, outputStream, bs);
        }
    }
}

