/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.DoubleArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class DoubleArrayCodec
implements Codec<double[]> {
    @Override
    public double[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            DoubleArrayType type = context.getDataTypeAnnotation(DoubleArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            return IntStream.range(0, l).mapToDouble(i -> inputStream.readDouble(o + i * 8, order)).toArray();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding double array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, double[] values) {
        try {
            DoubleArrayType type = context.getDataTypeAnnotation(DoubleArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            IntStream.range(0, Math.min(l, values.length)).forEach(i -> outputStream.writeDouble(o + i * 8, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding double array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Double>> {
        @Override
        public Collection<Double> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(DoubleArrayCodec.this.decode(context, inputStream)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Double> collection) {
            double[] doubles = collection.stream().mapToDouble(Double::doubleValue).toArray();
            DoubleArrayCodec.this.encode(context, outputStream, doubles);
        }
    }

    public class WrapperCodec
    implements Codec<Double[]> {
        @Override
        public Double[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            return (Double[])DoubleStream.of(DoubleArrayCodec.this.decode(context, inputStream)).mapToObj(Double::valueOf).toArray(Double[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Double[] values) {
            double[] doubles = Stream.of(values).mapToDouble(i -> i).toArray();
            DoubleArrayCodec.this.encode(context, outputStream, doubles);
        }
    }
}

