/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.FloatArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class FloatArrayCodec
implements Codec<float[]> {
    @Override
    public float[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            FloatArrayType type = context.getDataTypeAnnotation(FloatArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 4) / 4 + 1;
            }
            float[] values = new float[l];
            IntStream.range(0, l).forEach(i -> {
                values[i] = inputStream.readFloat(o + i * 4, order);
            });
            return values;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding float array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, float[] values) {
        try {
            FloatArrayType type = context.getDataTypeAnnotation(FloatArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 4) / 4 + 1;
            }
            IntStream.range(0, Math.min(l, values.length)).forEach(i -> outputStream.writeFloat(o + i * 4, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding float array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Float>> {
        @Override
        public Collection<Float> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (float b : FloatArrayCodec.this.decode(context, inputStream)) {
                    collection.add(Float.valueOf(b));
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Float> collection) {
            float[] bs = new float[collection.size()];
            Float[] values = (Float[])collection.stream().toArray(Float[]::new);
            IntStream.range(0, bs.length).forEach(i -> {
                bs[i] = values[i].floatValue();
            });
            FloatArrayCodec.this.encode(context, outputStream, bs);
        }
    }

    public class WrapperCodec
    implements Codec<Float[]> {
        @Override
        public Float[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            float[] floats = FloatArrayCodec.this.decode(context, inputStream);
            Float[] values = new Float[floats.length];
            IntStream.range(0, floats.length).forEach(i -> {
                values[i] = Float.valueOf(floats[i]);
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Float[] values) {
            float[] floats = new float[values.length];
            IntStream.range(0, floats.length).forEach(i -> {
                floats[i] = values[i].floatValue();
            });
            FloatArrayCodec.this.encode(context, outputStream, floats);
        }
    }
}

