/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.FloatType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class FloatCodec
implements Codec<Float> {
    @Override
    public Float decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            FloatType type = context.getDataTypeAnnotation(FloatType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return Float.valueOf(inputStream.readFloat(type.offset(), order));
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding float type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Float value) {
        try {
            FloatType type = context.getDataTypeAnnotation(FloatType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeFloat(type.offset(), order, value.floatValue());
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding float type.", e);
        }
    }
}

