/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

public class CRC64ISO {
    public static final long POLYNOMIAL = 27L;
    public static final long INITIAL_VALUE = -1L;
    protected long polynomial = 27L;
    protected long initialValue = -1L;
    protected static final long[] TABLE = new long[256];

    private static long reflect8(int v) {
        return Long.reverse(v) >>> 56;
    }

    private static long reflect64(long v) {
        return Long.reverse(v);
    }

    public long calculate(byte[] data) {
        long crc = this.initialValue;
        for (byte b : data) {
            int idx = (int)((crc ^ CRC64ISO.reflect8(b & 0xFF)) & 0xFFL);
            crc = crc >>> 8 ^ TABLE[idx];
        }
        crc = CRC64ISO.reflect64(crc) ^ 0xFFFFFFFFFFFFFFFFL;
        return crc;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long crc = i;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1L) != 0L) {
                    crc = crc >>> 1 ^ 0x1BL;
                    continue;
                }
                crc >>>= 1;
            }
            CRC64ISO.TABLE[i] = crc;
        }
    }
}

