/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class BoolCodec
implements Codec<Boolean> {
    @Override
    public Boolean decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            BoolType type = context.getDataTypeAnnotation(BoolType.class);
            BitOrder order = context.getBitOrder(type::bitOrder);
            return inputStream.readBool(type.byteOffset(), type.bitOffset(), order);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding bool type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Boolean value) {
        try {
            BoolType type = context.getDataTypeAnnotation(BoolType.class);
            BitOrder bitOrder = context.getBitOrder(type::bitOrder);
            outputStream.writeBool(type.byteOffset(), type.bitOffset(), bitOrder, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding the bool type.", e);
        }
    }
}

