/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.CharType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class CharCodec
implements Codec<Character> {
    @Override
    public Character decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            CharType type = context.getDataTypeAnnotation(CharType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return Character.valueOf((char)inputStream.readUInt16(type.offset(), order));
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding char type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Character value) {
        try {
            CharType type = context.getDataTypeAnnotation(CharType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeUInt16(type.offset(), order, value.charValue());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding char type.", e);
        }
    }
}

