/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.pipeline;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Checksum;
import org.indunet.fastproto.checksum.ChecksumUtils;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class ChecksumFlow
extends Pipeline<PipelineContext> {
    @Override
    public void process(PipelineContext context) {
        Graph graph = context.getGraph();
        if (graph == null) {
            this.forward(context);
            return;
        }
        List checksumFields = graph.stream().filter(r -> r.getReferenceType() == Reference.ReferenceType.CLASS).map(Reference::getProtocolClass).distinct().flatMap(clazz -> {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                f.setAccessible(true);
            }
            return Arrays.stream(fs);
        }).filter(f -> f.isAnnotationPresent(Checksum.class)).collect(Collectors.toCollection(ArrayList::new));
        if (context.getOutputStream() != null) {
            byte[] bytes = context.getOutputStream().toByteBuffer().toBytes();
            for (Field f2 : checksumFields) {
                Checksum c = f2.getAnnotation(Checksum.class);
                long crc = ChecksumUtils.calculate(bytes, c.start(), c.length(), c.type());
                this.writeChecksum(context, c.offset(), crc, c);
            }
        } else if (context.getInputStream() != null) {
            byte[] bytes = context.getInputStream().toByteBuffer().toBytes();
            for (Field f3 : checksumFields) {
                Checksum c = f3.getAnnotation(Checksum.class);
                long crc = ChecksumUtils.calculate(bytes, c.start(), c.length(), c.type());
                long actual = this.readChecksum(bytes, c.offset(), c);
                if (actual == crc) continue;
                throw new DecodingException("Checksum validation failed");
            }
        }
        this.forward(context);
    }

    private static BigInteger toUnsignedBigInteger(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        return BigInteger.valueOf(value).add(BigInteger.ONE.shiftLeft(64));
    }

    private void writeChecksum(PipelineContext ctx, int offset, long crc, Checksum c) {
        switch (c.type()) {
            case CRC8: 
            case CRC8_SMBUS: 
            case CRC8_MAXIM: 
            case XOR8: 
            case LRC8: {
                ctx.getOutputStream().writeUInt8(offset, (int)crc);
                break;
            }
            case CRC16: 
            case CRC16_CCITT: 
            case CRC16_MODBUS: {
                ctx.getOutputStream().writeUInt16(offset, c.byteOrder(), (int)crc);
                break;
            }
            case CRC32: 
            case CRC32C: {
                ctx.getOutputStream().writeUInt32(offset, c.byteOrder(), crc);
                break;
            }
            case CRC64_ECMA182: 
            case CRC64_ISO: {
                ctx.getOutputStream().writeUInt64(offset, c.byteOrder(), ChecksumFlow.toUnsignedBigInteger(crc));
            }
        }
    }

    private long readChecksum(byte[] bytes, int offset, Checksum c) {
        switch (c.type()) {
            case CRC8: 
            case CRC8_SMBUS: 
            case CRC8_MAXIM: 
            case XOR8: 
            case LRC8: {
                return (long)bytes[offset] & 0xFFL;
            }
            case CRC16: 
            case CRC16_CCITT: 
            case CRC16_MODBUS: {
                if (c.byteOrder() == ByteOrder.LITTLE) {
                    return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
                }
                return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
            }
            case CRC32: 
            case CRC32C: {
                if (c.byteOrder() == ByteOrder.LITTLE) {
                    return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24;
                }
                return ((long)bytes[offset] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
            }
            case CRC64_ECMA182: 
            case CRC64_ISO: {
                if (c.byteOrder() == ByteOrder.LITTLE) {
                    return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
                }
                return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
            }
        }
        return 0L;
    }

    @Override
    public long getCode() {
        return 0L;
    }
}

