/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import org.indunet.fastproto.Decoder;
import org.indunet.fastproto.Encoder;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Resolver;
import org.indunet.fastproto.io.ByteBuffer;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.pipeline.Pipeline;
import org.indunet.fastproto.pipeline.PipelineContext;

public class FastProto {
    public static <T> T decode(byte[] bytes, Class<T> clazz) {
        Graph graph = Resolver.resolve(clazz);
        PipelineContext context = PipelineContext.builder().inputStream(new ByteBufferInputStream(bytes)).clazz(clazz).graph(graph).build();
        Pipeline.getDecodeFlow().process(context);
        return (T)context.getObject();
    }

    public static Decoder decode(byte[] bytes) {
        return new Decoder(bytes);
    }

    public static byte[] encode(Object object) {
        Graph graph = Resolver.resolve(object.getClass());
        PipelineContext context = PipelineContext.builder().outputStream(new ByteBufferOutputStream()).object(object).clazz(object.getClass()).graph(graph).build();
        Pipeline.getEncodeFlow().process(context);
        return context.getOutputStream().toByteBuffer().toBytes();
    }

    public static byte[] encode(Object object, int length) {
        byte[] bytes = new byte[length];
        FastProto.encode(object, bytes);
        return bytes;
    }

    public static void encode(Object object, byte[] buffer) {
        Graph graph = Resolver.resolve(object.getClass());
        PipelineContext context = PipelineContext.builder().object(object).clazz(object.getClass()).outputStream(new ByteBufferOutputStream(new ByteBuffer(buffer))).graph(graph).build();
        Pipeline.getEncodeFlow().process(context);
    }

    public static Encoder create() {
        return new Encoder();
    }

    public static Encoder create(int length) {
        return new Encoder(new byte[length]);
    }
}

