/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import org.indunet.fastproto.checksum.CRC;

public class CRC8
extends CRC {
    public static final int CRC8_POLYNOMIAL = 7;
    public static final int CRC8_INITIAL_VALUE = 0;
    public static final int CRC8_CCITT_POLYNOMIAL = 7;
    public static final int CRC8_CCITT_INITIAL_VALUE = 255;
    public static final int CRC8_DALLAS_MAXIM_POLYNOMIAL = 49;
    public static final int CRC8_DALLAS_MAXIM_INITIAL_VALUE = 0;
    protected int polynomial = 7;
    protected int initialValue = 0;

    @Override
    public int getPolynomial() {
        return this.polynomial;
    }

    @Override
    public void setPolynomial(int polynomial) {
        this.polynomial = polynomial;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public int calculate(byte[] data) {
        int crc = this.initialValue;
        for (byte b : data) {
            crc ^= b & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((crc & 0x80) != 0) {
                    crc = crc << 1 ^ this.polynomial;
                    continue;
                }
                crc <<= 1;
            }
        }
        return crc & 0xFF;
    }
}

