/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import org.indunet.fastproto.annotation.Checksum;
import org.indunet.fastproto.checksum.BCC;
import org.indunet.fastproto.checksum.CRC16;
import org.indunet.fastproto.checksum.CRC16CCITT;
import org.indunet.fastproto.checksum.CRC16Modbus;
import org.indunet.fastproto.checksum.CRC32;
import org.indunet.fastproto.checksum.CRC32C;
import org.indunet.fastproto.checksum.CRC64ECMA182;
import org.indunet.fastproto.checksum.CRC64ISO;
import org.indunet.fastproto.checksum.CRC8;
import org.indunet.fastproto.checksum.CRC8Maxim;
import org.indunet.fastproto.checksum.CRC8SMBus;
import org.indunet.fastproto.checksum.LRC;
import org.indunet.fastproto.exception.CodecException;

public class ChecksumUtils {
    protected static final CRC8 CRC8_INSTANCE = new CRC8();
    protected static final CRC8SMBus CRC8_SMBUS_INSTANCE = new CRC8SMBus();
    protected static final CRC8Maxim CRC8_MAXIM_INSTANCE = new CRC8Maxim();
    protected static final BCC BCC_INSTANCE = new BCC();
    protected static final LRC LRC_INSTANCE = new LRC();
    protected static final CRC16 CRC16_INSTANCE = new CRC16();
    protected static final CRC16Modbus CRC16_MODBUS_INSTANCE = new CRC16Modbus();
    protected static final CRC16CCITT CRC16_CCITT_INSTANCE = new CRC16CCITT();
    protected static final CRC32 CRC32_INSTANCE = new CRC32();
    protected static final CRC32C CRC32C_INSTANCE = new CRC32C();
    protected static final CRC64ECMA182 CRC64_ECMA182_INSTANCE = new CRC64ECMA182();
    protected static final CRC64ISO CRC64_ISO_INSTANCE = new CRC64ISO();

    public static int crc8(byte[] data) {
        return CRC8_INSTANCE.calculate(data);
    }

    public static int crc8smbus(byte[] data) {
        return CRC8_SMBUS_INSTANCE.calculate(data);
    }

    public static int crc8maxim(byte[] data) {
        return CRC8_MAXIM_INSTANCE.calculate(data);
    }

    public static int bcc(byte[] data) {
        return BCC_INSTANCE.calculate(data);
    }

    public static int lrc(byte[] data) {
        return LRC_INSTANCE.calculate(data);
    }

    public static int crc16(byte[] data) {
        return CRC16_INSTANCE.calculate(data);
    }

    public static int crc16modbus(byte[] data) {
        return CRC16_MODBUS_INSTANCE.calculate(data);
    }

    public static int crc16ccitt(byte[] data) {
        return CRC16_CCITT_INSTANCE.calculate(data);
    }

    public static int crc32(byte[] data) {
        return CRC32_INSTANCE.calculate(data);
    }

    public static int crc32c(byte[] data) {
        return CRC32C_INSTANCE.calculate(data);
    }

    public static long crc64ecma182(byte[] data) {
        return CRC64_ECMA182_INSTANCE.calculate(data);
    }

    public static long crc64iso(byte[] data) {
        return CRC64_ISO_INSTANCE.calculate(data);
    }

    public static long calculate(byte[] data, int offset, int length, Checksum.Type type) {
        byte[] slice = new byte[length];
        System.arraycopy(data, offset, slice, 0, length);
        switch (type) {
            case CRC8: {
                return ChecksumUtils.crc8(slice) & 0xFF;
            }
            case CRC8_SMBUS: {
                return ChecksumUtils.crc8smbus(slice) & 0xFF;
            }
            case CRC8_MAXIM: {
                return ChecksumUtils.crc8maxim(slice) & 0xFF;
            }
            case XOR8: {
                return ChecksumUtils.bcc(slice) & 0xFF;
            }
            case LRC8: {
                return ChecksumUtils.lrc(slice) & 0xFF;
            }
            case CRC16: {
                return ChecksumUtils.crc16(slice) & 0xFFFF;
            }
            case CRC16_MODBUS: {
                return ChecksumUtils.crc16modbus(slice) & 0xFFFF;
            }
            case CRC16_CCITT: {
                return ChecksumUtils.crc16ccitt(slice) & 0xFFFF;
            }
            case CRC32: {
                return (long)ChecksumUtils.crc32(slice) & 0xFFFFFFFFL;
            }
            case CRC32C: {
                return (long)ChecksumUtils.crc32c(slice) & 0xFFFFFFFFL;
            }
            case CRC64_ECMA182: {
                return ChecksumUtils.crc64ecma182(slice);
            }
            case CRC64_ISO: {
                return ChecksumUtils.crc64iso(slice);
            }
        }
        throw new CodecException("Unsupported checksum type: " + (Object)((Object)type));
    }
}

