/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.annotation.AsciiArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class AsciiArrayCodec
implements Codec<char[]> {
    @Override
    public char[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            AsciiArrayType type = context.getDataTypeAnnotation(AsciiArrayType.class);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = inputStream.toByteBuffer().reverse(type.offset(), type.length());
            char[] chars = new char[l];
            IntStream.range(0, l).forEach(i -> {
                chars[i] = (char)inputStream.readInt8(o + i);
            });
            return chars;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding ascii array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, char[] chars) {
        try {
            AsciiArrayType type = context.getDataTypeAnnotation(AsciiArrayType.class);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = outputStream.toByteBuffer().reverse(type.offset(), type.length());
            IntStream.range(0, Math.min(l, chars.length)).forEach(i -> outputStream.writeInt8(o + i, chars[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding ascii array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Character>> {
        @Override
        public Collection<Character> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (char c : AsciiArrayCodec.this.decode(context, inputStream)) {
                    collection.add(Character.valueOf(c));
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Character> collection) {
            char[] chars = new char[collection.size()];
            Character[] values = (Character[])collection.stream().toArray(Character[]::new);
            IntStream.range(0, chars.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            AsciiArrayCodec.this.encode(context, outputStream, chars);
        }
    }

    public class WrapperCodec
    implements Codec<Character[]> {
        @Override
        public Character[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            char[] chars = AsciiArrayCodec.this.decode(context, inputStream);
            return (Character[])IntStream.range(0, chars.length).mapToObj(i -> Character.valueOf(chars[i])).toArray(Character[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Character[] values) {
            char[] chars = new char[values.length];
            IntStream.range(0, values.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            AsciiArrayCodec.this.encode(context, outputStream, chars);
        }
    }
}

