/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.DoubleType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class DoubleCodec
implements Codec<Double> {
    @Override
    public Double decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            DoubleType type = context.getDataTypeAnnotation(DoubleType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return inputStream.readDouble(type.offset(), order);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding double type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Double value) {
        try {
            DoubleType type = context.getDataTypeAnnotation(DoubleType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeDouble(type.offset(), order, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding double type.", e);
        }
    }
}

