/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class ShortArrayCodec
implements Codec<short[]> {
    @Override
    public short[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            short[] values = new short[l];
            IntStream.range(0, l).forEach(i -> {
                values[i] = inputStream.readShort(o + i * 2, order);
            });
            return values;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding short array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, short[] values) {
        try {
            Int16ArrayType type = context.getDataTypeAnnotation(Int16ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> outputStream.writeShort(o + i * 2, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding short array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Short>> {
        @Override
        public Collection<Short> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (short b : ShortArrayCodec.this.decode(context, inputStream)) {
                    collection.add(b);
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Short> collection) {
            short[] ss = new short[collection.size()];
            Short[] values = (Short[])collection.stream().toArray(Short[]::new);
            IntStream.range(0, ss.length).forEach(i -> {
                ss[i] = values[i];
            });
            ShortArrayCodec.this.encode(context, outputStream, ss);
        }
    }

    public class WrapperCodec
    implements Codec<Short[]> {
        @Override
        public Short[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            short[] shorts = ShortArrayCodec.this.decode(context, inputStream);
            Short[] values = new Short[shorts.length];
            IntStream.range(0, shorts.length).forEach(i -> {
                values[i] = shorts[i];
            });
            return values;
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Short[] values) {
            short[] shorts = new short[values.length];
            IntStream.range(0, shorts.length).forEach(i -> {
                shorts[i] = values[i];
            });
            ShortArrayCodec.this.encode(context, outputStream, shorts);
        }
    }
}

