/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.nio.charset.Charset;
import org.indunet.fastproto.annotation.StringType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class StringCodec
implements Codec<String> {
    @Override
    public String decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            StringType type = context.getDataTypeAnnotation(StringType.class);
            Charset set = Charset.forName(type.charset());
            byte[] bytes = inputStream.readBytes(type.offset(), type.length());
            return new String(bytes, set);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding string type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, String value) {
        try {
            StringType type = context.getDataTypeAnnotation(StringType.class);
            Charset set = Charset.forName(type.charset());
            outputStream.writeBytes(type.offset(), value.getBytes(set));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding string type.", e);
        }
    }

    public class StringBuilderCodec
    implements Codec<StringBuilder> {
        @Override
        public StringBuilder decode(CodecContext context, ByteBufferInputStream inputStream) {
            String str = StringCodec.this.decode(context, inputStream);
            return new StringBuilder(str);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, StringBuilder value) {
            StringCodec.this.encode(context, outputStream, value.toString());
        }
    }

    public class StringBufferCodec
    implements Codec<StringBuffer> {
        @Override
        public StringBuffer decode(CodecContext context, ByteBufferInputStream inputStream) {
            String str = StringCodec.this.decode(context, inputStream);
            return new StringBuffer(str);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, StringBuffer value) {
            StringCodec.this.encode(context, outputStream, value.toString());
        }
    }
}

