/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt16ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt16ArrayCodec
implements Codec<int[]> {
    @Override
    public int[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            return IntStream.range(0, l).map(i -> inputStream.readUInt16(o + i * 2, order)).toArray();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint16 array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, int[] values) {
        try {
            UInt16ArrayType type = context.getDataTypeAnnotation(UInt16ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            IntStream.range(0, l).forEach(i -> outputStream.writeUInt16(o + i * 2, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding uint16 array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt16ArrayCodec.this.decode(context, inputStream)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Integer> collection) {
            UInt16ArrayCodec.this.encode(context, outputStream, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            return (Integer[])IntStream.of(UInt16ArrayCodec.this.decode(context, inputStream)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            UInt16ArrayCodec.this.encode(context, outputStream, ints);
        }
    }
}

