/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt32Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class UInt32Codec
implements Codec<Long> {
    @Override
    public Long decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            UInt32Type type = context.getDataTypeAnnotation(UInt32Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return inputStream.readUInt32(type.offset(), order);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint32 type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Long value) {
        try {
            UInt32Type type = context.getDataTypeAnnotation(UInt32Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeUInt32(type.offset(), order, value);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding uint32 type.", e);
        }
    }
}

