/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.indunet.fastproto.annotation.UInt8ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt8ArrayCodec
implements Codec<int[]> {
    @Override
    public int[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            UInt8ArrayType type = context.getDataTypeAnnotation(UInt8ArrayType.class);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = inputStream.toByteBuffer().reverse(type.offset(), type.length());
            return IntStream.range(0, l).map(i -> inputStream.readUInt8(o + i)).toArray();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint8 array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, int[] values) {
        try {
            UInt8ArrayType type = context.getDataTypeAnnotation(UInt8ArrayType.class);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = outputStream.toByteBuffer().reverse(type.offset(), type.length());
            IntStream.range(0, l).forEach(i -> outputStream.writeUInt8(o + i, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding uint8 array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Integer>> {
        @Override
        public Collection<Integer> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt8ArrayCodec.this.decode(context, inputStream)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Integer> collection) {
            UInt8ArrayCodec.this.encode(context, outputStream, collection.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Integer[]> {
        @Override
        public Integer[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            return (Integer[])IntStream.of(UInt8ArrayCodec.this.decode(context, inputStream)).mapToObj(Integer::valueOf).toArray(Integer[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Integer[] values) {
            int[] ints = Stream.of(values).mapToInt(i -> i).toArray();
            UInt8ArrayCodec.this.encode(context, outputStream, ints);
        }
    }
}

