/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.formula;

public class FormulaBuilderTemplate {
    public static final String PACKAGE = "org.indunet.fastproto.formula";
    private final String expression;
    private final String className;
    private final String fileName;
    private final String fullName;
    private final String sourceCode;

    public FormulaBuilderTemplate(Class<?> inputType, String lambda) {
        this.expression = lambda.endsWith(";") || lambda.endsWith("}") ? lambda : lambda + ";";
        this.className = "Formula" + (inputType.getTypeName() + lambda).hashCode();
        this.fileName = this.className + ".java";
        this.fullName = "org.indunet.fastproto.formula." + this.className;
        this.sourceCode = String.format("package %s;%n%nimport java.util.function.Function;%nimport org.indunet.fastproto.formula.FormulaBuilder;%n%npublic class %s implements FormulaBuilder {%n    @Override%n    public Function build() {%n        Function<%s, Object> func = %s%n        return func;%n    }%n}%n", PACKAGE, this.className, inputType.getTypeName(), this.expression);
    }

    public String fileName() {
        return this.fileName;
    }

    public String fullName() {
        return this.fullName;
    }

    public String toSourceCode() {
        return this.sourceCode;
    }
}

