/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.reflect.Field;
import java.util.Optional;
import lombok.NonNull;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.annotation.DefaultBitOrder;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;

public class BitOrderFlow
extends ResolvePipeline {
    protected static final BitOrder DEFAULT_BIT_ORDER = BitOrder.LSB_0;

    @Override
    public void process(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        BitOrder bitOrder = this.getBitOrder(reference);
        reference.setBitOrder(bitOrder);
        this.forward(reference);
    }

    protected BitOrder getBitOrder(Reference reference) {
        if (reference.getReferenceType() == Reference.ReferenceType.CLASS) {
            Class<?> protocolClass = reference.getProtocolClass();
            return Optional.ofNullable(protocolClass.getAnnotation(DefaultBitOrder.class)).map(DefaultBitOrder::value).orElse(DEFAULT_BIT_ORDER);
        }
        if (reference.getReferenceType() == Reference.ReferenceType.FIELD) {
            Field field = reference.getField();
            return Optional.ofNullable(field.getAnnotation(DefaultBitOrder.class)).map(DefaultBitOrder::value).orElseGet(() -> Optional.ofNullable(reference.getField().getDeclaringClass()).map(c -> c.getAnnotation(DefaultBitOrder.class)).map(DefaultBitOrder::value).orElse(DEFAULT_BIT_ORDER));
        }
        return DEFAULT_BIT_ORDER;
    }
}

