/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.lang.reflect.Field;
import java.util.Optional;
import lombok.NonNull;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.DefaultByteOrder;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;

public class ByteOrderFlow
extends ResolvePipeline {
    @Override
    public void process(@NonNull Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (reference.getReferenceType() == Reference.ReferenceType.CLASS) {
            Class<?> protocolClass = reference.getProtocolClass();
            ByteOrder endianPolicy = Optional.ofNullable(protocolClass.getAnnotation(DefaultByteOrder.class)).map(DefaultByteOrder::value).orElse(ByteOrder.nativeOrder());
            reference.setByteOrder(endianPolicy);
        } else if (reference.getReferenceType() == Reference.ReferenceType.FIELD) {
            Field field = reference.getField();
            ByteOrder endianPolicy = Optional.ofNullable(field.getAnnotation(DefaultByteOrder.class)).map(DefaultByteOrder::value).orElseGet(() -> Optional.of(reference.getField().getDeclaringClass()).map(c -> c.getAnnotation(DefaultByteOrder.class)).map(DefaultByteOrder::value).orElse(ByteOrder.nativeOrder()));
            reference.setByteOrder(endianPolicy);
        }
        this.forward(reference);
    }
}

