/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve;

import java.text.MessageFormat;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.indunet.fastproto.annotation.Validator;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.ResolvingException;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.resolve.ResolvePipeline;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.mapper.CodecMapper;
import org.indunet.fastproto.mapper.JavaTypeMapper;

public class CodecFlow
extends ResolvePipeline {
    @Override
    public void process(Reference reference) {
        CodecContext ctx = CodecContext.builder().dataTypeAnnotation(reference.getDataTypeAnnotation()).fieldType(reference.getField().getType()).field(reference.getField()).defaultByteOrder(reference.getByteOrder()).defaultBitOrder(reference.getBitOrder()).build();
        reference.setDecoder(this.resolveDecoder(reference, ctx));
        reference.setEncoder(this.resolveEncoder(reference, ctx));
        this.validateReference(reference);
        this.forward(reference);
    }

    protected Function<ByteBufferInputStream, ?> resolveDecoder(Reference reference, CodecContext context) {
        if (reference.getDecodingFormulaClass() != null) {
            return CodecMapper.getDecoder(context, reference.getDecodingFormulaClass());
        }
        if (reference.getDecodingLambda() != null) {
            Class javaType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
            Function<ByteBufferInputStream, ?> decoder = CodecMapper.getDefaultDecoder(context, javaType);
            return decoder.andThen(reference.getDecodingLambda());
        }
        return CodecMapper.getDecoder(context, null);
    }

    protected BiConsumer<ByteBufferOutputStream, Object> resolveEncoder(Reference reference, CodecContext context) {
        if (reference.getEncodingFormulaClass() != null) {
            return CodecMapper.getEncoder(context, reference.getEncodingFormulaClass());
        }
        if (reference.getEncodingLambda() != null) {
            Class javaType = JavaTypeMapper.get(reference.getDataTypeAnnotation().annotationType());
            BiConsumer<ByteBufferOutputStream, ? super Object> encoder = CodecMapper.getDefaultEncoder(context, javaType);
            Function func = reference.getEncodingLambda();
            return (outputStream, value) -> encoder.accept((ByteBufferOutputStream)outputStream, func.apply(value));
        }
        return CodecMapper.getEncoder(context, null);
    }

    protected void validateReference(Reference reference) {
        try {
            ValidatorContext ctx = ValidatorContext.builder().field(reference.getField()).typeAnnotation(reference.getDataTypeAnnotation()).protocolType(reference.getProtocolType()).decodingFormulaClass(reference.getDecodingFormulaClass()).encodingFormulaClass(reference.getEncodingFormulaClass()).build();
            Validator validator = reference.getDataTypeAnnotation().annotationType().getAnnotation(Validator.class);
            TypeValidator.create(validator.value()).process(ctx);
        }
        catch (ResolvingException e) {
            throw new ResolvingException(MessageFormat.format("Failed resolving the field of %s", reference.getField().toString()), e);
        }
    }
}

