/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.graph.resolve.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.graph.resolve.validate.TypeValidator;
import org.indunet.fastproto.graph.resolve.validate.ValidatorContext;
import org.indunet.fastproto.util.TypeUtils;

public class EncodingFormulaValidator
extends TypeValidator {
    @Override
    public void process(ValidatorContext context) {
        Class<? extends Function> encodeFormula = context.getEncodingFormulaClass();
        Annotation typeAnnotation = context.getTypeAnnotation();
        Field field = context.getField();
        if (encodeFormula != null) {
            Arrays.stream(encodeFormula.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).map(i -> ((ParameterizedType)i).getActualTypeArguments()).map(a -> a[0]).filter(t -> this.matchType((Type)t, field)).findAny().orElseThrow(() -> new EncodingException(String.format("Data type annotation %s and field %s does not match", typeAnnotation.annotationType().getName(), field.getName())));
        }
        this.forward(context);
    }

    private boolean matchType(Type t, Field field) {
        if (field.getType().isPrimitive()) {
            return t == TypeUtils.wrapperClass(field.getType().getName());
        }
        if (field.getType().isEnum()) {
            return ((Class)t).isAssignableFrom(field.getType());
        }
        return t == field.getType();
    }
}

