/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.io;

import org.indunet.fastproto.io.ByteBuffer;

public abstract class ByteBufferIOStream {
    protected ByteBuffer byteBuffer;
    protected int byteIndex;
    protected int bitIndex;

    public ByteBufferIOStream(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        this.byteIndex = 0;
        this.bitIndex = 0;
    }

    public void align(int alignment) {
        if (alignment <= 0 || (alignment & alignment - 1) != 0) {
            throw new IllegalArgumentException("alignment must be a positive power of two");
        }
        int index = this.byteIndex;
        int after = index + (alignment - 1) & ~(alignment - 1);
        this.byteIndex = Math.max(after, 0);
    }

    public void skip() {
        ++this.byteIndex;
    }

    public void skip(int num) {
        if (num >= 0) {
            this.byteIndex += num;
        } else {
            throw new IllegalArgumentException("num must be a positive number.");
        }
    }

    public ByteBuffer toByteBuffer() {
        return this.byteBuffer;
    }
}

