/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.processor;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.indunet.fastproto.annotation.GenerateCodec;

@SupportedAnnotationTypes(value={"org.indunet.fastproto.annotation.GenerateCodec"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CodecProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elements = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(GenerateCodec.class)) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            String pkg = elements.getPackageOf(type).getQualifiedName().toString();
            String simple = type.getSimpleName().toString();
            String className = simple + "Codec";
            String qualified = pkg.isEmpty() ? className : pkg + "." + className;
            try {
                JavaFileObject file = this.processingEnv.getFiler().createSourceFile(qualified, type);
                Writer writer = file.openWriter();
                Throwable throwable = null;
                try {
                    writer.write("package " + pkg + ";\n\n");
                    writer.write("public class " + className + " {\n");
                    writer.write("    public static " + simple + " decode(byte[] bytes) {\n");
                    writer.write("        return org.indunet.fastproto.FastProto.decode(bytes, " + simple + ".class);\n");
                    writer.write("    }\n");
                    writer.write("    public static byte[] encode(" + simple + " obj) {\n");
                    writer.write("        return org.indunet.fastproto.FastProto.encode(obj);\n");
                    writer.write("    }\n");
                    writer.write("}\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return true;
    }
}

