/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.util;

import java.math.BigInteger;
import java.util.Arrays;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.util.ReverseUtils;

public class DecodeUtils {
    public static boolean readBool(byte[] bytes, int byteOffset, int bitOffset) {
        return DecodeUtils.readBool(bytes, byteOffset, bitOffset, BitOrder.LSB_0);
    }

    public static boolean readBool(byte[] bytes, int byteOffset, int bitOffset, BitOrder order) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new DecodingException("Out of byte range.");
        }
        int o = ReverseUtils.reverse(bytes, byteOffset);
        if (order == BitOrder.MSB_0) {
            bitOffset = 7 - bitOffset;
        }
        return (bytes[o] & 1 << bitOffset) != 0;
    }

    public static byte readByte(byte[] bytes, int offset) {
        int o = ReverseUtils.reverse(bytes, offset);
        return bytes[o];
    }

    public static short readShort(byte[] bytes, int offset) {
        return DecodeUtils.readShort(bytes, offset, ByteOrder.LITTLE);
    }

    public static short readShort(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        short value = 0;
        if (order == ByteOrder.LITTLE) {
            value = (short)(value | bytes[o] & 0xFF);
            value = (short)(value | bytes[o + 1] << 8);
        } else if (order == ByteOrder.BIG) {
            value = (short)(value | bytes[o + 1] & 0xFF);
            value = (short)(value | bytes[o] << 8);
        }
        return value;
    }

    public static int readInt8(byte[] bytes, int offset) {
        int o = ReverseUtils.reverse(bytes, offset);
        return bytes[o];
    }

    public static int readInt16(byte[] bytes, int offset) {
        return DecodeUtils.readInt16(bytes, offset, ByteOrder.LITTLE);
    }

    public static int readInt16(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        int value = 0;
        if (order == ByteOrder.BIG) {
            value = (short)(value | bytes[o + 1] & 0xFF);
            value = (short)(value | bytes[o] << 8);
        } else {
            value = (short)(value | bytes[o] & 0xFF);
            value = (short)(value | bytes[o + 1] << 8);
        }
        return value;
    }

    public static int readInt32(byte[] bytes, int offset) {
        return DecodeUtils.readInt32(bytes, offset, ByteOrder.LITTLE);
    }

    public static int readInt32(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        int value = 0;
        if (order == ByteOrder.LITTLE) {
            value |= bytes[o] & 0xFF;
            value |= (bytes[o + 1] & 0xFF) << 8;
            value |= (bytes[o + 2] & 0xFF) << 16;
            value |= (bytes[o + 3] & 0xFF) << 24;
        } else if (order == ByteOrder.BIG) {
            value |= bytes[o + 3] & 0xFF;
            value |= (bytes[o + 2] & 0xFF) << 8;
            value |= (bytes[o + 1] & 0xFF) << 16;
            value |= (bytes[o] & 0xFF) << 24;
        }
        return value;
    }

    public static long readInt64(byte[] bytes, int offset) {
        return DecodeUtils.readInt64(bytes, offset, ByteOrder.LITTLE);
    }

    public static long readInt64(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        long value = 0L;
        if (order == ByteOrder.LITTLE) {
            value |= (long)(bytes[o] & 0xFF);
            value |= ((long)bytes[o + 1] & 0xFFL) << 8;
            value |= ((long)bytes[o + 2] & 0xFFL) << 16;
            value |= ((long)bytes[o + 3] & 0xFFL) << 24;
            value |= ((long)bytes[o + 4] & 0xFFL) << 32;
            value |= ((long)bytes[o + 5] & 0xFFL) << 40;
            value |= ((long)bytes[o + 6] & 0xFFL) << 48;
            value |= ((long)bytes[o + 7] & 0xFFL) << 56;
        } else if (order == ByteOrder.BIG) {
            value |= (long)(bytes[o + 7] & 0xFF);
            value |= ((long)bytes[o + 6] & 0xFFL) << 8;
            value |= ((long)bytes[o + 5] & 0xFFL) << 16;
            value |= ((long)bytes[o + 4] & 0xFFL) << 24;
            value |= ((long)bytes[o + 3] & 0xFFL) << 32;
            value |= ((long)bytes[o + 2] & 0xFFL) << 40;
            value |= ((long)bytes[o + 1] & 0xFFL) << 48;
            value |= ((long)bytes[o] & 0xFFL) << 56;
        }
        return value;
    }

    public static int readUInt8(byte[] bytes, int offset) {
        int o = ReverseUtils.reverse(bytes, offset);
        return bytes[o] & 0xFF;
    }

    public static int readUInt16(byte[] bytes, int offset) {
        return DecodeUtils.readUInt16(bytes, offset, ByteOrder.LITTLE);
    }

    public static int readUInt16(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        if (order == ByteOrder.BIG) {
            return (bytes[o] & 0xFF) * 256 + (bytes[o + 1] & 0xFF);
        }
        return (bytes[o + 1] & 0xFF) * 256 + (bytes[o] & 0xFF);
    }

    public static long readUInt32(byte[] bytes, int offset) {
        return (long)DecodeUtils.readInt32(bytes, offset, ByteOrder.LITTLE) & 0xFFFFFFFFL;
    }

    public static long readUInt32(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        long value = 0L;
        if (order == ByteOrder.LITTLE) {
            value |= (long)(bytes[o] & 0xFF);
            value |= ((long)bytes[o + 1] & 0xFFL) << 8;
            value |= ((long)bytes[o + 2] & 0xFFL) << 16;
            value |= ((long)bytes[o + 3] & 0xFFL) << 24;
        } else if (order == ByteOrder.BIG) {
            value |= (long)(bytes[o + 3] & 0xFF);
            value |= ((long)bytes[o + 2] & 0xFFL) << 8;
            value |= ((long)bytes[o + 1] & 0xFFL) << 16;
            value |= ((long)bytes[o] & 0xFFL) << 24;
        }
        return value;
    }

    public static BigInteger readUInt64(byte[] bytes, int offset) {
        return DecodeUtils.readUInt64(bytes, offset, ByteOrder.LITTLE);
    }

    public static BigInteger readUInt64(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        long low = 0L;
        long high = 0L;
        if (order == ByteOrder.LITTLE) {
            low |= (long)(bytes[o] & 0xFF);
            low |= ((long)bytes[o + 1] & 0xFFL) << 8;
            low |= ((long)bytes[o + 2] & 0xFFL) << 16;
            low |= ((long)bytes[o + 3] & 0xFFL) << 24;
            high |= (long)bytes[o + 4] & 0xFFL;
            high |= ((long)bytes[o + 5] & 0xFFL) << 8;
            high |= ((long)bytes[o + 6] & 0xFFL) << 16;
            high |= ((long)bytes[o + 7] & 0xFFL) << 24;
        } else if (order == ByteOrder.BIG) {
            low |= (long)(bytes[o + 7] & 0xFF);
            low |= ((long)bytes[o + 6] & 0xFFL) << 8;
            low |= ((long)bytes[o + 5] & 0xFFL) << 16;
            low |= ((long)bytes[o + 4] & 0xFFL) << 24;
            high |= (long)bytes[o + 3] & 0xFFL;
            high |= ((long)bytes[o + 2] & 0xFFL) << 8;
            high |= ((long)bytes[o + 1] & 0xFFL) << 16;
            high |= ((long)bytes[o] & 0xFFL) << 24;
        }
        return new BigInteger(String.valueOf(high)).multiply(new BigInteger(String.valueOf(0x100000000L))).add(new BigInteger(String.valueOf(low)));
    }

    public static float readFloat(byte[] bytes, int offset) {
        return DecodeUtils.readFloat(bytes, offset, ByteOrder.LITTLE);
    }

    public static float readFloat(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        int value = 0;
        if (order == ByteOrder.LITTLE) {
            value |= bytes[o] & 0xFF;
            value |= (bytes[o + 1] & 0xFF) << 8;
            value |= (bytes[o + 2] & 0xFF) << 16;
            value |= (bytes[o + 3] & 0xFF) << 24;
        } else if (order == ByteOrder.BIG) {
            value |= bytes[o + 3] & 0xFF;
            value |= (bytes[o + 2] & 0xFF) << 8;
            value |= (bytes[o + 1] & 0xFF) << 16;
            value |= (bytes[o] & 0xFF) << 24;
        }
        return Float.intBitsToFloat(value);
    }

    public static double readDouble(byte[] bytes, int offset) {
        return DecodeUtils.readDouble(bytes, offset, ByteOrder.LITTLE);
    }

    public static double readDouble(byte[] bytes, int offset, ByteOrder order) {
        int o = ReverseUtils.reverse(bytes, offset);
        long value = 0L;
        if (order == ByteOrder.LITTLE) {
            value |= (long)bytes[o] & 0xFFL;
            value |= ((long)bytes[o + 1] & 0xFFL) << 8;
            value |= ((long)bytes[o + 2] & 0xFFL) << 16;
            value |= ((long)bytes[o + 3] & 0xFFL) << 24;
            value |= ((long)bytes[o + 4] & 0xFFL) << 32;
            value |= ((long)bytes[o + 5] & 0xFFL) << 40;
            value |= ((long)bytes[o + 6] & 0xFFL) << 48;
            value |= ((long)bytes[o + 7] & 0xFFL) << 56;
        } else if (order == ByteOrder.BIG) {
            value |= (long)bytes[o + 7] & 0xFFL;
            value |= ((long)bytes[o + 6] & 0xFFL) << 8;
            value |= ((long)bytes[o + 5] & 0xFFL) << 16;
            value |= ((long)bytes[o + 4] & 0xFFL) << 24;
            value |= ((long)bytes[o + 3] & 0xFFL) << 32;
            value |= ((long)bytes[o + 2] & 0xFFL) << 40;
            value |= ((long)bytes[o + 1] & 0xFFL) << 48;
            value |= ((long)bytes[o] & 0xFFL) << 56;
        }
        return Double.longBitsToDouble(value);
    }

    public static byte[] readBytes(byte[] bytes, int offset, int length) {
        int l;
        int o = ReverseUtils.reverse(bytes, offset);
        if (o + (l = ReverseUtils.reverse(bytes, offset, length)) > bytes.length) {
            throw new IllegalArgumentException("Out of the bytes range.");
        }
        return Arrays.copyOfRange(bytes, o, o + l);
    }
}

