/*
 * Copyright 2019-2021 indunet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.indunet.fastproto.annotation;

import org.indunet.fastproto.graph.resolve.validate.DecodingFormulaValidator;
import org.indunet.fastproto.graph.resolve.validate.EncodingFormulaValidator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for StringType. This annotation is used to mark fields of type String, StringBuilder, or StringBuffer.
 * The default charset used is UTF-8.
 *
 * @author Deng Ran
 * @since 1.1.0
 */
@DataType
@Validator({DecodingFormulaValidator.class, EncodingFormulaValidator.class})
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface StringType {
    /*
     * The byte offset of the field in the binary data.
     */
    int offset();

    /*
     * The length of the string.
     */
    int length() default 0;

    /*
     * Reference to a length field name in the same class. Accepts optional leading '$'.
     */
    String lengthRef() default "";

    /*
     * When true, encoder uses actual runtime length of the value instead of referenced length.
     */
    boolean useSelfOnEncode() default false;

    /*
     * Optional min/max constraints applied to the effective length.
     */
    int min() default Integer.MIN_VALUE;
    int max() default Integer.MAX_VALUE;

    /*
     * The charset of the field in the binary data.
     */
    String charset() default "UTF-8";
}
