/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.indunet.fastproto.BitOrder;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.AutoType;
import org.indunet.fastproto.annotation.BoolArrayType;
import org.indunet.fastproto.annotation.BoolType;
import org.indunet.fastproto.exception.ResolvingException;

public interface ProtocolType {
    public static <T> T proxy(AutoType autoType, Class<T> dataTypeAnnotationClass) {
        return (T)Proxy.newProxyInstance(ProtocolType.class.getClassLoader(), new Class[]{dataTypeAnnotationClass}, (proxy, method, args) -> {
            Method mth = Arrays.stream(autoType.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().get();
            if (Arrays.asList("offset", "byteOffset", "bitOffset", "length").contains(mth.getName())) {
                int[] ints = (int[])mth.invoke((Object)autoType, args);
                if (ints.length != 0) {
                    return ints[0];
                }
                throw new ResolvingException(String.format("Autotype lack of property %s", mth.getName()));
            }
            if (Arrays.asList("byteOrder", "bitOrder", "charset", "name", "lengthRef").contains(method.getName())) {
                return mth.invoke((Object)autoType, args);
            }
            if (mth.getName().equals("annotationType")) {
                return dataTypeAnnotationClass;
            }
            return null;
        });
    }

    public static ProtocolType proxy(Annotation typeAnnotation) {
        return (ProtocolType)Proxy.newProxyInstance(ProtocolType.class.getClassLoader(), new Class[]{ProtocolType.class, typeAnnotation.annotationType()}, (proxy, method, args) -> {
            switch (method.getName()) {
                case "getType": {
                    return typeAnnotation.annotationType();
                }
                case "size": {
                    try {
                        return typeAnnotation.annotationType().getDeclaredField("SIZE").getInt(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        return 0;
                    }
                }
                case "length": {
                    if (Arrays.stream(typeAnnotation.getClass().getMethods()).anyMatch(m -> m.getName().equals("length"))) {
                        return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals("length")).findAny().get().invoke((Object)typeAnnotation, args);
                    }
                    return 0;
                }
                case "defaultJavaType": {
                    try {
                        return (Class)typeAnnotation.annotationType().getDeclaredField("DEFAULT_JAVA_TYPE").get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        return null;
                    }
                }
            }
            if (typeAnnotation.annotationType() == BoolType.class && method.getName().equals("offset")) {
                return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals("byteOffset")).findAny().get().invoke((Object)typeAnnotation, args);
            }
            if (typeAnnotation.annotationType() == BoolArrayType.class && method.getName().equals("offset")) {
                return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals("byteOffset")).findAny().get().invoke((Object)typeAnnotation, args);
            }
            return Arrays.stream(typeAnnotation.getClass().getMethods()).filter(m -> m.getName().equals(method.getName())).findAny().get().invoke((Object)typeAnnotation, args);
        });
    }

    public int offset();

    public int byteOffset();

    public int bitOffset();

    public int length();

    public String name();

    public ByteOrder[] byteOrder();

    public BitOrder[] bitOrder();

    public Class<? extends Annotation> getType();

    public int size();
}

