/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import org.indunet.fastproto.checksum.CRC;

public class CRC16
extends CRC {
    public static final int CRC16_IBM_POLYNOMIAL = 32773;
    public static final int CRC16_IBM_INITIAL_VALUE = 0;
    public static final int CRC16_CCITT_POLYNOMIAL = 4129;
    public static final int CRC16_CCITT_INITIAL_VALUE = 65535;
    public static final int CRC16_MODBUS_POLYNOMIAL = 32773;
    public static final int CRC16_MODBUS_INITIAL_VALUE = 65535;
    protected int polynomial = 32773;
    protected int initialValue = 0;

    @Override
    public int getPolynomial() {
        return this.polynomial;
    }

    @Override
    public void setPolynomial(int polynomial) {
        this.polynomial = polynomial;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public int calculate(byte[] data) {
        int crc = this.initialValue;
        for (byte b : data) {
            b = CRC16.reverseBits(b);
            crc ^= (b & 0xFF) << 8;
            for (int i = 0; i < 8; ++i) {
                if ((crc & 0x8000) != 0) {
                    crc = crc << 1 ^ this.polynomial;
                    continue;
                }
                crc <<= 1;
            }
        }
        crc &= 0xFFFF;
        crc = this.reverseBits(crc, 16);
        return crc;
    }

    @Override
    public int calculate(byte[] data, int offset, int length) {
        int crc = this.initialValue;
        for (int i = 0; i < length; ++i) {
            byte b = CRC16.reverseBits(data[offset + i]);
            crc ^= (b & 0xFF) << 8;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 0x8000) != 0) {
                    crc = crc << 1 ^ this.polynomial;
                    continue;
                }
                crc <<= 1;
            }
        }
        crc &= 0xFFFF;
        crc = this.reverseBits(crc, 16);
        return crc;
    }
}

