/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

import org.indunet.fastproto.checksum.CRC;

public class CRC16CCITT
extends CRC {
    public static final int POLYNOMIAL = 4129;
    public static final int INITIAL_VALUE = 65535;
    protected int polynomial = 4129;
    protected int initialValue = 65535;

    @Override
    public int getPolynomial() {
        return this.polynomial;
    }

    @Override
    public void setPolynomial(int polynomial) {
        this.polynomial = polynomial;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public int calculate(byte[] data) {
        int crc = this.initialValue & 0xFFFF;
        for (byte b : data) {
            crc ^= (b & 0xFF) << 8;
            for (int i = 0; i < 8; ++i) {
                crc = (crc & 0x8000) != 0 ? (crc << 1 ^ this.polynomial) & 0xFFFF : crc << 1 & 0xFFFF;
            }
        }
        return crc & 0xFFFF;
    }

    @Override
    public int calculate(byte[] data, int offset, int length) {
        int crc = this.initialValue & 0xFFFF;
        for (int i = 0; i < length; ++i) {
            crc ^= (data[offset + i] & 0xFF) << 8;
            for (int j = 0; j < 8; ++j) {
                crc = (crc & 0x8000) != 0 ? (crc << 1 ^ this.polynomial) & 0xFFFF : crc << 1 & 0xFFFF;
            }
        }
        return crc & 0xFFFF;
    }
}

