/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.checksum;

public class CRC64ECMA182 {
    public static final long POLYNOMIAL = 4823603603198064275L;
    public static final long INITIAL_VALUE = 0L;
    protected long polynomial = 4823603603198064275L;
    protected long initialValue = 0L;
    protected static final long[] TABLE = new long[256];

    public long calculate(byte[] data) {
        long crc = this.initialValue;
        for (byte b : data) {
            int idx = (int)((crc >>> 56 ^ (long)(b & 0xFF)) & 0xFFL);
            crc = crc << 8 ^ TABLE[idx];
        }
        return crc;
    }

    public long calculate(byte[] data, int offset, int length) {
        long crc = this.initialValue;
        for (int i = 0; i < length; ++i) {
            int idx = (int)((crc >>> 56 ^ (long)(data[offset + i] & 0xFF)) & 0xFFL);
            crc = crc << 8 ^ TABLE[idx];
        }
        return crc;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long crc = (long)i << 56;
            for (int j = 0; j < 8; ++j) {
                if ((crc & Long.MIN_VALUE) != 0L) {
                    crc = crc << 1 ^ 0x42F0E1EBA9EA3693L;
                    continue;
                }
                crc <<= 1;
            }
            CRC64ECMA182.TABLE[i] = crc;
        }
    }
}

