/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.CharArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class CharArrayCodec
implements Codec<char[]> {
    @Override
    public char[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            CharArrayType type = context.getDataTypeAnnotation(CharArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            char[] chars = new char[l];
            IntStream.range(0, l).forEach(i -> {
                chars[i] = (char)inputStream.readUInt16(o + i * 2, order);
            });
            return chars;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding char array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, char[] values) {
        try {
            CharArrayType type = context.getDataTypeAnnotation(CharArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 2) / 2 + 1;
            }
            IntStream.range(0, Math.min(l, values.length)).forEach(i -> outputStream.writeUInt16(o + i * 2, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding char array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Character>> {
        @Override
        public Collection<Character> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                for (char c : CharArrayCodec.this.decode(context, inputStream)) {
                    collection.add(Character.valueOf(c));
                }
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Character> collection) {
            char[] chars = new char[collection.size()];
            Character[] values = (Character[])collection.stream().toArray(Character[]::new);
            IntStream.range(0, chars.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            CharArrayCodec.this.encode(context, outputStream, chars);
        }
    }

    public class WrapperCodec
    implements Codec<Character[]> {
        @Override
        public Character[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            char[] chars = CharArrayCodec.this.decode(context, inputStream);
            return (Character[])IntStream.range(0, chars.length).mapToObj(i -> Character.valueOf(chars[i])).toArray(Character[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Character[] values) {
            char[] chars = new char[values.length];
            IntStream.range(0, values.length).forEach(i -> {
                chars[i] = values[i].charValue();
            });
            CharArrayCodec.this.encode(context, outputStream, chars);
        }
    }
}

