/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int32Type;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class Int32Codec
implements Codec<Integer> {
    @Override
    public Integer decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int32Type type = context.getDataTypeAnnotation(Int32Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            return inputStream.readInt32(type.offset(), order);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int32 type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Integer value) {
        try {
            Int32Type type = context.getDataTypeAnnotation(Int32Type.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            outputStream.writeInt32(type.offset(), order, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int32 type.", e);
        }
    }
}

