/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.Int64ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class Int64ArrayCodec
implements Codec<long[]> {
    @Override
    public long[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            Int64ArrayType type = context.getDataTypeAnnotation(Int64ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            return IntStream.range(0, l).mapToLong(i -> inputStream.readInt64(o + i * 8, order)).toArray();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding int32 array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, long[] values) {
        try {
            Int64ArrayType type = context.getDataTypeAnnotation(Int64ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            IntStream.range(0, Math.min(l, values.length)).forEach(i -> outputStream.writeInt64(o + i * 8, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding int32 array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<Long>> {
        @Override
        public Collection<Long> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(Int64ArrayCodec.this.decode(context, inputStream)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<Long> collection) {
            Int64ArrayCodec.this.encode(context, outputStream, collection.stream().mapToLong(Long::longValue).toArray());
        }
    }

    public class WrapperCodec
    implements Codec<Long[]> {
        @Override
        public Long[] decode(CodecContext context, ByteBufferInputStream inputStream) {
            return (Long[])LongStream.of(Int64ArrayCodec.this.decode(context, inputStream)).mapToObj(Long::valueOf).toArray(Long[]::new);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Long[] values) {
            long[] longs = Stream.of(values).mapToLong(i -> i).toArray();
            Int64ArrayCodec.this.encode(context, outputStream, longs);
        }
    }
}

