/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.indunet.fastproto.annotation.StringType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class StringCodec
implements Codec<String> {
    private static final StringCodec INSTANCE = new StringCodec();

    @Override
    public String decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            int end;
            StringType type = context.getDataTypeAnnotation(StringType.class);
            Charset set = Charset.forName(type.charset());
            byte[] bytes = inputStream.readBytes(type.offset(), type.length());
            for (end = bytes.length; end > 0 && bytes[end - 1] == 0; --end) {
            }
            return new String(bytes, 0, end, set);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding string type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, String value) {
        try {
            StringType type = context.getDataTypeAnnotation(StringType.class);
            Charset set = Charset.forName(type.charset());
            byte[] src = value.getBytes(set);
            int l = outputStream.toByteBuffer().reverse(type.offset(), type.length());
            if (src.length >= l) {
                outputStream.writeBytes(type.offset(), Arrays.copyOfRange(src, 0, l));
            } else {
                byte[] padded = new byte[l];
                System.arraycopy(src, 0, padded, 0, src.length);
                outputStream.writeBytes(type.offset(), padded);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding string type.", e);
        }
    }

    public static class StringBuilderCodec
    implements Codec<StringBuilder> {
        @Override
        public StringBuilder decode(CodecContext context, ByteBufferInputStream inputStream) {
            String str = INSTANCE.decode(context, inputStream);
            return new StringBuilder(str);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, StringBuilder value) {
            INSTANCE.encode(context, outputStream, value.toString());
        }
    }

    public static class StringBufferCodec
    implements Codec<StringBuffer> {
        @Override
        public StringBuffer decode(CodecContext context, ByteBufferInputStream inputStream) {
            String str = INSTANCE.decode(context, inputStream);
            return new StringBuffer(str);
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, StringBuffer value) {
            INSTANCE.encode(context, outputStream, value.toString());
        }
    }
}

