/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.indunet.fastproto.FastProto;
import org.indunet.fastproto.annotation.StructArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.graph.Graph;
import org.indunet.fastproto.graph.Reference;
import org.indunet.fastproto.graph.Resolver;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;

public class StructArrayCodec<T>
implements Codec<Object> {
    @Override
    public Object decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            StructArrayType type = context.getDataTypeAnnotation(StructArrayType.class);
            Class<?> elemClass = type.element();
            Graph elemGraph = Resolver.resolve(elemClass);
            int elemSize = StructArrayCodec.inferFixedSize(elemGraph);
            int count = type.length();
            int base = inputStream.toByteBuffer().reverse(type.offset());
            ArrayList list = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                byte[] slice = inputStream.toByteBuffer().toBytes();
                int start = base + i * elemSize;
                byte[] elemBytes = Arrays.copyOfRange(slice, start, start + elemSize);
                Object elem = FastProto.decode(elemBytes, elemClass);
                list.add(elem);
            }
            Class<?> ft = context.getField().getType();
            if (ft.isArray()) {
                Object arr = Array.newInstance(elemClass, count);
                for (int i = 0; i < count; ++i) {
                    Array.set(arr, i, list.get(i));
                }
                return arr;
            }
            if (Collection.class.isAssignableFrom(ft)) {
                ArrayList coll = new ArrayList(count);
                coll.addAll(list);
                return coll;
            }
            throw new DecodingException("StructArrayType only supports arrays or collections");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding struct array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, Object value) {
        try {
            int i;
            StructArrayType type = context.getDataTypeAnnotation(StructArrayType.class);
            Class<?> elemClass = type.element();
            Graph elemGraph = Resolver.resolve(elemClass);
            int elemSize = StructArrayCodec.inferFixedSize(elemGraph);
            int count = type.length();
            int base = outputStream.toByteBuffer().reverse(type.offset());
            ArrayList<Object> list = new ArrayList<Object>();
            if (value.getClass().isArray()) {
                int n = Array.getLength(value);
                for (int i2 = 0; i2 < Math.min(count, n); ++i2) {
                    list.add(Array.get(value, i2));
                }
            } else if (value instanceof Collection) {
                i = 0;
                for (Object o : (Collection)value) {
                    if (i++ < count) {
                        list.add(o);
                        continue;
                    }
                    break;
                }
            } else {
                throw new EncodingException("StructArrayType only supports arrays or collections");
            }
            for (i = 0; i < list.size(); ++i) {
                Object elem = list.get(i);
                byte[] bytes = FastProto.encode(elem, elemSize);
                for (int b = 0; b < bytes.length; ++b) {
                    outputStream.writeByte(base + i * elemSize + b, bytes[b]);
                }
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new EncodingException("Fail encoding struct array type.", e);
        }
    }

    private static int inferFixedSize(Graph graph) {
        int max = 0;
        for (Reference r : graph.getValidReferences()) {
            int off = r.getProtocolType().offset();
            int span = 0;
            if (r.getProtocolType().size() > 0) {
                span = r.getProtocolType().size();
            } else if (r.getProtocolType().length() > 0) {
                span = r.getProtocolType().length();
            }
            if (off + span <= max) continue;
            max = off + span;
        }
        return max;
    }
}

