/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.codec;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.IntStream;
import org.indunet.fastproto.ByteOrder;
import org.indunet.fastproto.annotation.UInt64ArrayType;
import org.indunet.fastproto.codec.Codec;
import org.indunet.fastproto.codec.CodecContext;
import org.indunet.fastproto.exception.DecodingException;
import org.indunet.fastproto.exception.EncodingException;
import org.indunet.fastproto.io.ByteBufferInputStream;
import org.indunet.fastproto.io.ByteBufferOutputStream;
import org.indunet.fastproto.util.CollectionUtils;

public class UInt64ArrayCodec
implements Codec<BigInteger[]> {
    @Override
    public BigInteger[] decode(CodecContext context, ByteBufferInputStream inputStream) {
        try {
            UInt64ArrayType type = context.getDataTypeAnnotation(UInt64ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = inputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = inputStream.toByteBuffer().reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            return (BigInteger[])IntStream.range(0, l).mapToObj(i -> inputStream.readUInt64(o + i * 8, order)).toArray(BigInteger[]::new);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new DecodingException("Fail decoding uint64 array type.", e);
        }
    }

    @Override
    public void encode(CodecContext context, ByteBufferOutputStream outputStream, BigInteger[] values) {
        try {
            UInt64ArrayType type = context.getDataTypeAnnotation(UInt64ArrayType.class);
            ByteOrder order = context.getByteOrder(type::byteOrder);
            int o = outputStream.toByteBuffer().reverse(type.offset());
            int l = type.length();
            if (l < 0) {
                l = outputStream.toByteBuffer().reverse(type.offset(), type.length() * 8) / 8 + 1;
            }
            IntStream.range(0, l).forEach(i -> outputStream.writeUInt64(o + i * 8, order, values[i]));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            throw new EncodingException("Fail encoding uint64 array type.", e);
        }
    }

    public class CollectionCodec
    implements Codec<Collection<BigInteger>> {
        @Override
        public Collection<BigInteger> decode(CodecContext context, ByteBufferInputStream inputStream) {
            try {
                Class<?> type = context.getFieldType();
                Collection collection = CollectionUtils.newInstance(type);
                Arrays.stream(UInt64ArrayCodec.this.decode(context, inputStream)).forEach(collection::add);
                return collection;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DecodingException(String.format("Fail decoding collection type of %s", context.getFieldType().toString()), e);
            }
        }

        @Override
        public void encode(CodecContext context, ByteBufferOutputStream outputStream, Collection<BigInteger> collection) {
            UInt64ArrayCodec.this.encode(context, outputStream, (BigInteger[])collection.stream().toArray(BigInteger[]::new));
        }
    }
}

