/*
 * Decompiled with CFR 0.152.
 */
package org.indunet.fastproto.formula;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.tools.ToolProvider;
import org.indunet.fastproto.exception.ResolvingException;
import org.indunet.fastproto.formula.FormulaBuilderTemplate;
import org.indunet.fastproto.formula.compiler.JavaStringCompiler;

public interface FormulaBuilder {
    public static FormulaBuilder create(Class inputType, String lambda) {
        if (Boolean.parseBoolean(System.getProperty("fastproto.lambda.disabled", "false"))) {
            throw new ResolvingException("String lambda compilation is disabled. Set -Dfastproto.lambda.disabled=false or use a precompiled Function class.");
        }
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new ResolvingException("No system Java compiler (javax.tools). Run with a JDK or include jdk.compiler module, or avoid lambda formulas.");
        }
        try {
            JavaStringCompiler compiler = new JavaStringCompiler();
            FormulaBuilderTemplate template = new FormulaBuilderTemplate(inputType, lambda);
            Map<String, byte[]> results = compiler.compile(template.fileName(), template.toSourceCode());
            Class<?> clazz = compiler.loadClass(template.fullName(), results);
            return (FormulaBuilder)clazz.newInstance();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ResolvingException(String.format("Fail compiling lambda expression: %s", lambda), e);
        }
    }

    public Function build();
}

